package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is added on a pull request.
 * <p>
 * This does not include replies, which raise a {@link PullRequestCommentRepliedEvent}.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.comment.added")
public class PullRequestCommentAddedEvent extends PullRequestCommentEvent {

    /**
     * @param source      the component raising the event
     * @param pullRequest the pull request this comment relates to
     * @param comment     the comment
     * @since 6.6
     */
    public PullRequestCommentAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                        @Nonnull Comment comment) {
        super(source, pullRequest, comment, null, CommentAction.ADDED);
    }

    /**
     * @param source      the component raising the event
     * @param pullRequest the pull request this comment relates to
     * @param comment     the comment
     * @param parent      always {@code null} because this event is only published for top-level comments
     * @deprecated in 6.6 for removal in 8.0. Use {@link #PullRequestCommentAddedEvent(Object, PullRequest,
     *         Comment)} instead
     */
    @Deprecated
    public PullRequestCommentAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                        @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, pullRequest, comment, parent, CommentAction.ADDED);
    }
}
