package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * An event which is fired when a user or group has had a permission revoked.
 *
 * @see GlobalPermissionRevokedEvent
 * @see ProjectPermissionRevokedEvent
 * @see RepositoryPermissionRevokedEvent
 */
public interface PermissionRevokedEvent {

    /**
     * @return the affected group of {@code null} if a user was affected
     */
    @Nullable
    String getAffectedGroup();

    /**
     * @return the affected user of {@code null} if a group was affected
     */
    @Nullable
    ApplicationUser getAffectedUser();

    /**
     * @return the permission revoked
     */
    @Nonnull
    Permission getPermission();
}
