package com.atlassian.bitbucket.event.compare;

import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * An event that is raised when a source branch, tag, or commit is compared successfully with a destination branch, tag
 * or commit.
 *
 * @since 7.2
 */
@AsynchronousPreferred
public class DiffSuccessfulEvent extends ApplicationEvent {

    private final CompareRef fromRef;
    private final CompareRef toRef;

    public DiffSuccessfulEvent(@Nonnull Object source, @Nonnull CompareRef fromRef, @Nonnull CompareRef toRef) {
        super(source);
        this.fromRef = fromRef;
        this.toRef = toRef;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return fromRef;
    }

    @Nonnull
    public CompareRef getToRef() {
        return toRef;
    }
}
