package com.atlassian.bitbucket.event.commit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a comment is edited in a commit discussion.
 */
@AsynchronousPreferred
@EventName("stash.commit.comment.edited")
public class CommitDiscussionCommentEditedEvent extends CommitDiscussionCommentEvent {

    private final CommentSeverity previousSeverity;
    private final CommentState previousState;
    private final String previousText;

    /**
     * @deprecated in 6.7 for removal in 8.0. Use {@link #CommitDiscussionCommentEditedEvent(Object, CommitDiscussion,
     * Comment, Comment, String, CommentSeverity, CommentState)} instead.
     */
    @Deprecated
    public CommitDiscussionCommentEditedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                              @Nonnull Comment comment, @Nullable Comment parent,
                                              @Nonnull String previousText) {
        super(source, discussion, comment, parent, CommentAction.EDITED);

        this.previousText = requireNonNull(previousText, "previousText");

        previousSeverity = comment.getSeverity();
        previousState = comment.getState();
    }

    /**
     * @param source           the component raising the event
     * @param discussion       the commit discussion this comment relates to
     * @param comment          the comment
     * @param parent           the parent of this comment, or null if this is a top-level comment
     * @param previousText     the previous text of the comment
     * @param previousSeverity the previous severity of the comment
     * @param previousState    the previous state of the comment
     * @since 6.7
     */
    public CommitDiscussionCommentEditedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                              @Nonnull Comment comment, @Nullable Comment parent,
                                              @Nonnull String previousText, @Nonnull CommentSeverity previousSeverity,
                                              @Nonnull CommentState previousState) {
        super(source, discussion, comment, parent, CommentAction.EDITED);

        this.previousSeverity = requireNonNull(previousSeverity, "previousSeverity");
        this.previousState = requireNonNull(previousState, "previousState");
        this.previousText = requireNonNull(previousText, "previousText");
    }

    /**
     * @since 6.7
     */
    @Nonnull
    public CommentSeverity getPreviousSeverity() {
        return previousSeverity;
    }

    /**
     * @since 6.7
     */
    @Nonnull
    public CommentState getPreviousState() {
        return previousState;
    }

    @Nonnull
    public String getPreviousText() {
        return previousText;
    }
}
