package com.atlassian.bitbucket.event.backup;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a backup is canceled by a system administrator.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@EventName("stash.backup.cancelled")
public class BackupCanceledEvent extends BackupEndedEvent {

    public BackupCanceledEvent(@Nonnull Object source) {
        super(source);
    }
}
