package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.watcher.Watchable;

import javax.annotation.Nonnull;
import java.util.Set;

public interface CommitDiscussion extends Commentable, Watchable {

    @Nonnull
    String getCommitId();

    @Nonnull
    Set<CommitDiscussionParticipant> getParticipants();

    @Nonnull
    Repository getRepository();

    boolean isMerge();
}
