package com.atlassian.bitbucket.build.status;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * @since 7.6
 */
public interface TestResults {

    /**
     * @return count of how many tests failed, if known, {@link Optional#empty()} otherwise
     */
    @Nonnull
    Optional<Integer> getFailed();

    /**
     * @return count of how many tests were skipped, if known, {@link Optional#empty()} otherwise
     */
    @Nonnull
    Optional<Integer> getSkipped();

    /**
     * @return count of how many tests passed, if known, {@link Optional#empty()} otherwise
     */
    @Nonnull
    Optional<Integer> getSuccessful();
}
