package com.atlassian.bitbucket.build;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Date;

import static java.util.Objects.requireNonNull;

/**
 * @deprecated in 7.6 for removal in 8.0 Use {@link RepositoryBuildStatusSetRequest} instead
 */
@Deprecated
public class BuildStatusSetRequest {

    private final String commitId;
    private final long dateAdded;
    private final String description;
    private final String key;
    private final String name;
    private final BuildState state;
    private final String url;

    private BuildStatusSetRequest(Builder builder) {
        commitId = builder.commitId;
        dateAdded = builder.dateAdded > 0 ? builder.dateAdded : System.currentTimeMillis();
        description = builder.description;
        key = builder.key;
        name = builder.name;
        state = builder.state;
        url = builder.url;
    }

    @Nonnull
    public String getCommitId() {
        return commitId;
    }

    @Nonnull
    public Date getDateAdded() {
        return new Date(dateAdded);
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    @Nonnull
    public String getKey() {
        return key;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nonnull
    public BuildState getState() {
        return state;
    }

    @Nonnull
    public String getUrl() {
        return url;
    }

    public static class Builder extends BuilderSupport {

        private final String commitId;

        private long dateAdded;
        private String description;
        private String key;
        private String name;
        private BuildState state;
        private String url;

        public Builder(@Nonnull String commitId) {
            this.commitId = checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public BuildStatusSetRequest build() {
            checkNotBlank(key, "key");
            requireNonNull(state, "state");
            checkNotBlank(url, "url");

            return new BuildStatusSetRequest(this);
        }

        @Nonnull
        public Builder dateAdded(long value) {
            dateAdded = value;

            return this;
        }

        /**
         * This value is ignored. The underlying code will always use the current date instead of this value.
         *
         * @deprecated in 7.4 for removal in 8.0
         */
        @Deprecated
        @Nonnull
        public Builder dateAdded(@Nullable Date value) {
            dateAdded = value == null ? 0L : value.getTime();

            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            description = StringUtils.trimToNull(StringUtils.abbreviate(value, 255));

            return this;
        }

        @Nonnull
        public Builder key(@Nonnull String value) {
            key = checkNotBlank(value, "key");

            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            name = StringUtils.trimToNull(value);

            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState value) {
            state = requireNonNull(value, "state");

            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            url = checkNotBlank(value, "url");

            return this;
        }
    }
}