package com.atlassian.bitbucket.build;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;

/**
 * Manages build {@link BuildStatus statuses}.
 *
 * @deprecated in 7.6 for removal in 8.0. Please use {@link RepositoryBuildStatusService}
 */
@Deprecated
public interface BuildStatusService {

    /**
     * Retrieves a page of {@link BuildStatus build statuses} associated with the specified commit across all
     * repositories and branches. By default the page size is 100 and the order is {@link BuildOrder#NEWEST}
     *
     * @param commitId the {@link Commit#getId() ID} of the commit to retrieve builds for
     * @return a page of build statuses
     * @throws AuthorisationException if the current user is not licensed
     * @deprecated in 6.7 for removal in 8.0. Please use {@link BuildStatusService#findAll(String, PageRequest, BuildOrder)}
     */
    @Deprecated
    @Nonnull
    Page<BuildStatus> findAll(@Nonnull String commitId);

    /**
     * Retrieves a page of {@link BuildStatus build statuses} associated with the specified commit across all
     * repositories and branches.
     *
     * @param commitId the {@link Commit#getId() ID} of the commit to retrieve builds for
     * @param pageRequest the page to be returned
     * @param orderBy the field to order by in addition to descending date ordering
     * @return a page of build statuses
     * @throws AuthorisationException if the current user is not licensed
     * @since 6.7
     */
    @Nonnull
    Page<BuildStatus> findAll(@Nonnull String commitId, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy);

    /**
     * Retrieves a {@link BuildSummary summary} of all the builds associated with the specified commit across all
     * repositories and branches.
     *
     * @param commitId the {@link Commit#getId() ID} of the commit to retrieve a summary for
     * @return {@link BuildSummary stats} for all the builds associated with the {@code commitId}.
     * @throws AuthorisationException if the current user is not licensed
     */
    @Nonnull
    BuildSummary getSummary(@Nonnull String commitId);

    /**
     * Retrieves {@link BuildSummary summaries} for the builds associated with all of the specified commits across all
     * repositories and branches. If any of the specified commits do not have builds associated with them, their ID
     * will not be included in the returned {@code Map}.
     *
     * @return a map from {@code commit IDs} to {@link BuildSummary summaries}, which can have a length smaller than
     *         the number of specified commits if any do not have build statuses associated with them.
     * @throws AuthorisationException if the current user is not licensed
     * @see #getSummary(String)
     */
    @Nonnull
    Map<String, BuildSummary> getSummaries(@Nonnull Collection<String> commitIds);

    /**
     * Sets the build status globally for a commit, replacing any existing global status <em>with the same
     * <u>{@link BuildStatus#getKey key}</u></em>
     *
     * @param request describes the build status and the commit it should be associated with
     * @throws AuthorisationException if the current user is not licensed
     */
    void set(@Nonnull BuildStatusSetRequest request);
}
