package com.atlassian.bitbucket.build;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Date;

/**
 * A build result associated with a commit.
 *
 * @deprecated in 7.6 for removal in 8.0. Please use {@link RepositoryBuildStatus}
 */
@Deprecated
public interface BuildStatus {

    /**
     * The commit the build was run against.
     *
     * @since 7.6
     */
    @Nonnull
    String getCommitId();

    /**
     * State of the build.
     */
    @Nonnull
    BuildState getState();

    /**
     * Key associated with the build. For Bamboo, this is the plan key.
     */
    @Nonnull
    String getKey();

    /**
     * Optional name of the build.
     */
    @Nullable
    String getName();

    /**
     * URL to access the build result.
     */
    @Nonnull
    String getUrl();

    /**
     * The date the build result was added. This is equivelent to {@link #getUpdatedDate()}
     *
     * @deprecated in 7.4 for removal in 8.0. Please use {@link #getUpdatedDate()} or {@link #getCreatedDate()}
     */
    @Deprecated
    @Nonnull
    default Date getDateAdded() {
        return getUpdatedDate();
    }

    /**
     * @return the date that the build status was updated
     * @since 7.4
     */
    @Nonnull
    Date getUpdatedDate();

    /**
     * @return the date that the build status was first posted
     * @since 7.4
     */
    @Nonnull
    Date getCreatedDate();

    /**
     * An optional description of the build result.
     */
    @Nullable
    String getDescription();

}
