package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.annotation.Auditable;
import com.atlassian.bitbucket.event.annotation.Audited;

/**
 * Prior to 7.0, this enum specified the priority levels at which audit events could be raised. Lower
 * levels were filtered out first by consumers. {@link #NONE} could be used to cancel an inherited
 * {@link Audited &#064;Audited} annotation.
 * <p>
 * From 7.0 onward, specifying a {@link Priority} on {@link Audited} events is optional, and internally
 * any {@link Priority} specified will be ignored. This class and {@link Audited} will be removed in 8.0.
 * <p>
 * Consumers are recommended to use {@link Auditable} instead, and specify the relevant {@link CoverageLevel}
 * and {@link CoverageArea} for the event.
 *
 * @see Audited
 * @deprecated in 7.0 for removal in 8.0, without replacement.
 */
@Deprecated
public enum Priority {

    HIGH(1000),
    MEDIUM(700),
    LOW(300),
    NONE(0);

    private int weight;

    Priority(int weightToAdd) {
        weight = weightToAdd;
    }

    /**
     * Retrieves the weight of this priority relative to other priorities. When filtering, higher weighted priorities
     * will be filtered last.
     *
     * @return the weight of this priority
     */
    public int getWeight() {
        return weight;
    }
}
