package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.event.annotation.Auditable;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;

/**
 * Represents the set of built-in audit log channel names. Listeners may use the channels to determine whether
 * they are interested in the event.
 * <p>
 * {@link Audited#channels()} have been replaced in 7.0 by specifying {@link AuditResource}s on an
 * {@link AuditEvent} directly (via {@link Auditable}). A {@link Project} or a {@link Repository repository} is able to
 * be represented by an {@link AuditResource}, offering similar behaviour to adding an event to the {@link #PROJECT_UI}
 * or {@link #REPOSITORY_UI} channels.
 * <p>
 * When processing events to be {@link Audited}, any {@link Channels} specified in the annotation will be converted by
 * the system into {@link Project project} or {@link Repository repository} {@link AuditResource}s, if an
 * {@link AuditEntryConverter} type converter is used, and the {@link Project project} and/or {@link Repository repository} is
 * supplied on the generated {@link AuditEntry}. {@link Channels} will otherwise be ignored (i.e. specifying channels
 * when using an {@link AuditEventConverter} type converter will have no effect).
 * <p>
 * It is recommended the consumers use {@link Auditable} instead of {@link Audited} and specify {@link AuditResource}s
 * directly as support for {@link Audited} and {@link Channels} will be removed in 8.0.
 *
 * @see Audited
 * @deprecated in 7.0 for removal in 8.0. {@link AuditResource}s on {@link AuditEvent}s should be used
 *             instead.
 */
@Deprecated
public class Channels {

    /**
     * Used to notify listeners that the event should be displayed in the audit UI for a project.
     */
    public static final String PROJECT_UI = "audit.channel.ui.project";
    /**
     * Used to notify listeners that the event should be displayed in the audit UI for a repository.
     */
    public static final String REPOSITORY_UI = "audit.channel.ui.repository";

    private Channels() {
        throw new UnsupportedOperationException(getClass().getName() + " is not intended to be instantiated.");
    }
}
