package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.bitbucket.event.annotation.Auditable;
import com.atlassian.bitbucket.event.annotation.Audited;

import javax.annotation.Nonnull;

/**
 * Converts an {@link Audited} event into an {@link AuditEntry} (a legacy representation suitable for auditing).
 * <p>
 * The supplied {@link AuditEntryBuilder} from {@link #convert(Object, AuditEntryBuilder)} will have the source IP
 * address already set.
 * <p>
 * Implementations <i>must</i> have a nullary (no argument) constructor and are intended to be <i>lightweight, stateless
 * classes</i>. Converters are instantiated for <i>each event</i> and discarded after the event has been converted.
 * <p>
 * {@link AuditEntryConverter} has been replaced by {@link AuditEventConverter} in 7.0. Internally, an
 * {@link AuditEntry} produced by an implementation of this converter is then subsequently converted to an
 * {@link AuditEvent} (possibly with some information loss or default values being used due to slight differences
 * between the audit representations) before being processed for auditing. Consumers are recommended to use
 * {@link Auditable} with an {@link AuditEventConverter} to convert to an {@link AuditEvent} directly, instead of using
 * {@link Audited} with an {@link AuditEntryConverter}.
 *
 * @param <T> the type of the original event
 * @see AuditEntry
 * @see AuditEntryBuilder
 * @see Audited
 * @deprecated in 7.0 for removal in 8.0. {@link AuditEventConverter} should be used instead.
 */
@Deprecated
public interface AuditEntryConverter<T> {

    /**
     * Converts an {@link Audited} event into an {@link AuditEntry}.
     *
     * @param builder an audit entry builder which has the source IP address set by the caller
     * @param event   the original annotated event
     * @return the details of the original event in the standard audit format
     */
    @Nonnull
    AuditEntry convert(@Nonnull T event, AuditEntryBuilder builder);
}
