/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositorySearchRequest {
    private final String name;
    private final String projectName;
    private final Permission permission;
    private final Repository.State state;
    private final RepositoryVisibility visibility;

    private RepositorySearchRequest(String name, String projectName, Permission permission, RepositoryVisibility visibility, Repository.State state) {
        this.name = name;
        this.projectName = projectName;
        this.permission = permission;
        this.state = state;
        this.visibility = visibility;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public Repository.State getState() {
        return this.state;
    }

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    @Nullable
    public RepositoryVisibility getVisibility() {
        return this.visibility;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public boolean isEmpty() {
        return !this.hasName() && !this.hasProjectName() && !this.hasPermission() && !this.hasState() && !this.hasVisibility();
    }

    public static class Builder {
        private String name;
        private String projectName;
        private Permission permission;
        private Repository.State state;
        private RepositoryVisibility visibility;

        public Builder() {
        }

        public Builder(@Nonnull RepositorySearchRequest request) {
            this.name = Objects.requireNonNull(request, "request").getName();
            this.permission = request.getPermission();
            this.state = request.getState();
            this.visibility = request.getVisibility();
        }

        @Nonnull
        public RepositorySearchRequest build() {
            return new RepositorySearchRequest(this.name, this.projectName, this.permission, this.visibility, this.state);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder projectName(@Nullable String value) {
            this.projectName = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder permission(@Nullable Permission value) {
            Preconditions.checkArgument((value == null || value.isResource(Repository.class) ? 1 : 0) != 0, (Object)"The provided permission is not valid for repositories");
            this.permission = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable Repository.State value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder visibility(@Nullable RepositoryVisibility value) {
            this.visibility = value;
            return this;
        }
    }
}

