/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.permission.PermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class ProjectPermissionGrantRequestedEvent
extends ProjectPermissionEvent
implements PermissionGrantRequestedEvent {
    private final CancelState cancelState;

    public ProjectPermissionGrantRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nonnull Project project, @Nullable String affectedGroup, @Nullable ApplicationUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, project, affectedGroup, affectedUser);
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

