/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum StandardRepositoryHookTrigger implements RepositoryHookTrigger
{
    BRANCH_CREATE("branch-create"),
    BRANCH_DELETE("branch-delete"),
    FILE_EDIT("file-edit"),
    MERGE("merge", true),
    PULL_REQUEST_MERGE("pull-request-merge"),
    REPO_PUSH("push", true),
    TAG_CREATE("tag-create"),
    TAG_DELETE("tag-delete"),
    UNKNOWN("unknown");

    private final boolean abortOnFirstVeto;
    private final String id;

    private StandardRepositoryHookTrigger(String id) {
        this(id, false);
    }

    private StandardRepositoryHookTrigger(String id, boolean abortOnFirstVeto) {
        this.abortOnFirstVeto = abortOnFirstVeto;
        this.id = id;
    }

    @Nonnull
    public static Optional<StandardRepositoryHookTrigger> fromId(@Nullable String id) {
        for (StandardRepositoryHookTrigger trigger : StandardRepositoryHookTrigger.values()) {
            if (!trigger.id.equals(id)) continue;
            return Optional.of(trigger);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isAbortOnFirstVeto() {
        return this.abortOnFirstVeto;
    }
}

