/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangesetsRequest {
    private static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final List<String> commitIds;
    private final boolean ignoreMissing;
    private final int maxChangesPerCommit;
    private final int maxMessageLength;
    private final Repository repository;

    private ChangesetsRequest(Builder builder) {
        this.commitIds = builder.commitIds.build();
        this.ignoreMissing = builder.ignoreMissing;
        this.maxChangesPerCommit = builder.maxChangesPerCommit;
        this.repository = builder.repository;
        this.maxMessageLength = builder.maxMessageLength;
        if (this.commitIds.isEmpty()) {
            throw new IllegalStateException("At least one commit ID must be provided to retrieve changesets");
        }
        if (this.maxChangesPerCommit < 1) {
            throw new IllegalStateException("The maximum number of changes to include per changeset must be greater than 0");
        }
    }

    @Nonnull
    public Iterable<String> getCommitIds() {
        return this.commitIds;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public int getMaxChangesPerCommit() {
        return this.maxChangesPerCommit;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<String> commitIds;
        private final Repository repository;
        private boolean ignoreMissing;
        private int maxChangesPerCommit;
        private int maxMessageLength;

        public Builder(@Nonnull Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.commitIds = ImmutableList.builder();
            this.maxMessageLength = -1;
            this.maxChangesPerCommit = 5;
        }

        @Nonnull
        public ChangesetsRequest build() {
            return new ChangesetsRequest(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.commitIds, value);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.commitIds, value, values);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.commitIds, values);
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public Builder maxChangesPerCommit(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"At least one change must be included for each changeset");
            this.maxChangesPerCommit = value;
            return this;
        }

        @Nonnull
        public Builder messageLength(int maxMessageLength) {
            this.maxMessageLength = maxMessageLength;
            return this;
        }
    }
}

