/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.project;

import com.atlassian.bitbucket.event.project.ProjectEvent;
import com.atlassian.bitbucket.project.Project;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class AbstractProjectModificationEvent
extends ProjectEvent {
    protected final Project newValue;
    protected final Project oldValue;

    public AbstractProjectModificationEvent(@Nonnull Object source, @Nonnull Project project, @Nonnull Project oldValue, @Nonnull Project newValue) {
        super(source, project);
        this.newValue = (Project)Preconditions.checkNotNull((Object)newValue, (Object)"newValue");
        this.oldValue = (Project)Preconditions.checkNotNull((Object)oldValue, (Object)"oldValue");
    }

    @Nonnull
    public Project getNewValue() {
        return this.newValue;
    }

    @Nonnull
    public Project getOldValue() {
        return this.oldValue;
    }

    public boolean isDescriptionChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getDescription(), (Object)this.getNewValue().getDescription());
    }

    public boolean isKeyChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getKey(), (Object)this.getNewValue().getKey());
    }

    public boolean isNameChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getName(), (Object)this.getNewValue().getName());
    }
}

