/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JobCreationRequest {
    private final ApplicationUser initiator;
    private final int progressPercentage;
    private final String progressMessage;
    private final JobState state;
    private final String type;

    private JobCreationRequest(Builder builder) {
        this.initiator = builder.initiator;
        this.progressPercentage = builder.progressPercentage;
        this.progressMessage = builder.progressMessage;
        this.state = builder.state;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    @Nonnull
    public Optional<ApplicationUser> getInitiator() {
        return Optional.ofNullable(this.initiator);
    }

    @Nonnull
    public Optional<String> getProgressMessage() {
        return Optional.ofNullable(this.progressMessage);
    }

    public int getProgressPercentage() {
        return this.progressPercentage;
    }

    @Nonnull
    public JobState getState() {
        return this.state;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobCreationRequest that = (JobCreationRequest)o;
        return this.getProgressPercentage() == that.getProgressPercentage() && com.google.common.base.Objects.equal(this.getInitiator().map(ApplicationUser::getId), that.getInitiator().map(ApplicationUser::getId)) && com.google.common.base.Objects.equal(this.getProgressMessage(), that.getProgressMessage()) && com.google.common.base.Objects.equal((Object)((Object)this.getState()), (Object)((Object)that.getState())) && com.google.common.base.Objects.equal((Object)this.getType(), (Object)that.getType());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getInitiator().map(ApplicationUser::getId), this.getProgressPercentage(), this.getProgressMessage(), this.getState(), this.getType()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("initiator", (Object)this.initiator).add("progressPercentage", this.progressPercentage).add("progressMessage", (Object)this.progressMessage).add("state", (Object)this.state).add("type", (Object)this.type).toString();
    }

    public static class Builder {
        private ApplicationUser initiator;
        private JobState state = JobState.INITIALISING;
        private String type;
        private int progressPercentage;
        private String progressMessage;

        @Nonnull
        public JobCreationRequest build() {
            return new JobCreationRequest(this);
        }

        @Nonnull
        public Builder initiator(@Nullable ApplicationUser value) {
            this.initiator = value;
            return this;
        }

        @Nonnull
        public Builder progressMessage(@Nullable String value) {
            this.progressMessage = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder progressPercentage(int value) {
            this.progressPercentage = Math.max(0, Math.min(value, 100));
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull JobState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull String value) {
            this.type = Objects.requireNonNull(StringUtils.trimToNull((String)value), "type");
            return this;
        }
    }
}

