package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.NonNegativeIntValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * Validate a number is a non-negative integer.
 *
 * <p>{@code null} are considered valid to follow the JSR-303 convention:
 * ex: {@code @Min}, {@code @Max}, {@code @Email}, {@code @SafeHtml}, etc. .</p>
 *
 * @see Int
 */
@Constraint(validatedBy = {NonNegativeIntValidator.class})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD})
public @interface NonNegativeInt {

    String message() default "{com.atlassian.bitbucket.validation.required.nonnegative.int.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
