package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @see UserAdminService#updateServiceUser(ServiceUserUpdateRequest)
 */
public class ServiceUserUpdateRequest extends AbstractServiceUserRequest {

    private final int id;

    private ServiceUserUpdateRequest(Builder builder) {
        super(builder);

        id = builder.id;
    }

    /**
     * @return the ID of the {@link ServiceUser} to update
     */
    public int getId() {
        return id;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private Integer id;

        /**
         * @param id the ID of the {@link ServiceUser} to update
         */
        public Builder(int id) {
            this.id = id;
        }

        /**
         * @param user the {@link ServiceUser} to update
         */
        public Builder(@Nonnull ServiceUser user) {
            id = checkNotNull(user, "user").getId();
            active(user.isActive());
            displayName(user.getDisplayName());
            emailAddress(user.getEmailAddress());
            label(user.getLabel());
            name(user.getName());
        }

        @Nonnull
        public ServiceUserUpdateRequest build() {
            return new ServiceUserUpdateRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}
