package com.atlassian.bitbucket.task;

import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.annotation.RequiredString;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Date;

/**
 * A task on a pull request.
 */
public interface Task extends PropertySupport {

    /**
     * @return the anchor of the task, such as a pull request's comment
     */
    @Nonnull
    TaskAnchor getAnchor();

    /**
     * @return the author of the task
     */
    @Nonnull
    ApplicationUser getAuthor();

    /**
     * @return the date when the task was originally created
     */
    @Nonnull
    Date getCreatedDate();

    /**
     * @return the task's ID, which is globally unique
     */
    long getId();

    /**
     * @return the operations allowed by the current user or {@code null} if none are permitted
     */
    @Nullable
    TaskOperations getPermittedOperations();

    /**
     * @return the state (e.g. open or resolved) of the task
     */
    @Nonnull
    TaskState getState();

    /**
     * @return the raw text of the task (limited to 32k)
     */
    @Nonnull
    @RequiredString(size = 32 * 1024)
    String getText();
}
