package com.atlassian.bitbucket.setting;

import com.atlassian.bitbucket.hook.repository.RepositoryHookService;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * A builder for {@link Settings}
 *
 * @see RepositoryHookService#createSettingsBuilder()
 */
public interface SettingsBuilder {

    /**
     * Add an entry to the settings
     * @param key the key of the setting
     * @param value the value of the setting
     * @return the builder
     */
    @Nonnull
    SettingsBuilder add(@Nonnull String key, @Nonnull String value);

    /**
     * @see #add(String, String)
     */
    @Nonnull
    SettingsBuilder add(@Nonnull String key, boolean value);

    /**
     * @see #add(String, String)
     */
    @Nonnull
    SettingsBuilder add(@Nonnull String key, int value);

    /**
     * @see #add(String, String)
     */
    @Nonnull
    SettingsBuilder add(@Nonnull String key, long value);

    /**
     * @see #add(String, String)
     */
    @Nonnull
    SettingsBuilder add(@Nonnull String key, double value);

    /**
     * Add all entries in the {@code Map} of values.
     * <p>
     * Only maps with entries which could be manually via one of the {@code add(key, value)} methods are acceptable.
     *
     * @param values the map of values
     * @return the builder.
     * @throws IllegalArgumentException if any of the entries are unacceptable
     */
    @Nonnull
    SettingsBuilder addAll(@Nonnull Map<String, ?> values);

    /**
     * Add all the {@code Settings}
     *
     * @param settings the settings instance
     * @return the builder
     * @throws IllegalArgumentException if any of the entries are unacceptable
     */
    @Nonnull
    SettingsBuilder addAll(@Nonnull Settings settings);

    /**
     * @return the newly created {@link Settings} instance
     */
    @Nonnull
    Settings build();

}
