package com.atlassian.bitbucket.request;

import javax.annotation.Nonnull;

/**
 * Interface for providing request details to {@link RequestManager}. These details are used to set up logging and
 * profiling.
 */
public interface RequestInfoProvider extends RequestMetadata {

    /**
     * @return the underlying 'raw' request object
     */
    @Nonnull
    Object getRawRequest();

    /**
     * @return the underlying 'raw' response object
     */
    @Nonnull
    Object getRawResponse();
}
