package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.InvalidNameException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Indicates the ref name supplied was syntactically incorrect.
 */
public class InvalidRefNameException extends InvalidNameException {

    private final String refName;

    public InvalidRefNameException(KeyedMessage message, String refName) {
        super(message);
        this.refName = checkNotNull(refName, "refName must be non-null");
    }

    @Nonnull
    public String getRefName() {
        return refName;
    }
}
