package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

public abstract class AbstractRepositoryRefsRequest {

    private final Repository repository;
    private final String filterText;
    private final RefOrder order;

    protected AbstractRepositoryRefsRequest(AbstractBuilder<?, ?> builder) {
        repository = builder.repository;
        filterText = builder.filterText;
        order = builder.order;
    }

    /**
     * @return the repository to retrieve refs from
     */
    @Nonnull
    public Repository getRepository() {
        return repository;
    }

    /**
     * @return optional text for filtering returned refs
     */
    @Nullable
    public String getFilterText() {
        return filterText;
    }

    /**
     * @return the ordering to apply when listing refs; if {@code null}, the order is determined by the SCM
     */
    @Nullable
    public RefOrder getOrder() {
        return order;
    }

    public abstract static class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractRepositoryRefsRequest>
            extends BuilderSupport {

        private final Repository repository;

        private String filterText;
        private RefOrder order;

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.repository = checkNotNull(repository, "repository");
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B filterText(@Nullable String value) {
            filterText = value;

            return self();
        }

        @Nonnull
        public B order(@Nullable RefOrder value) {
            order = value;

            return self();
        }

        @Nonnull
        protected abstract B self();
    }
}
