package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

/**
 * Request object used for {@link PullRequestService#delete(PullRequestDeleteRequest) deleting a pull request}.
 *
 * @since 5.1
 */
public class PullRequestDeleteRequest extends AbstractPullRequestRequest {

    private final int version;

    private PullRequestDeleteRequest(@Nonnull Builder builder) {
        super(builder);
        version = builder.version;
    }

    /**
     * Retrieves the expected {@link PullRequest#getVersion version} for the pull request. If the pull request's
     * actual version does not match, a {@link PullRequestOutOfDateException} will be thrown to indicate that the
     * delete was requested on stale data.
     *
     * @return the pull request version to delete
     */
    public int getVersion() {
        return version;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private final int version;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
            version = pullRequest.getVersion();
        }

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);
            this.version = version;
        }

        @Nonnull
        public PullRequestDeleteRequest build() {
            return new PullRequestDeleteRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
