package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Exception that is thrown when a {@link Project#getKey() project key} or {@link Project#getNamespace() namespace}
 * has been changed and the project is retrieved using the old key/namespace.
 *
 * @since 5.0
 */
public class ProjectMovedException extends EntityMovedException {

    private static final long serialVersionUID = 1L;

    private final String oldKey;
    private final String oldNamespace;
    private final Project project;

    public ProjectMovedException(@Nonnull Project project, @Nullable String projectNamespace,
                                 @Nonnull String projectKey, @Nonnull KeyedMessage message) {
        super(message);

        this.oldKey = projectKey;
        this.oldNamespace = projectNamespace;
        this.project = project;
    }

    @Nonnull
    public String getOldKey() {
        return oldKey;
    }

    @Nullable
    public String getOldNamespace() {
        return oldNamespace;
    }

    @Nonnull
    public Project getProject() {
        return project;
    }
}
