package com.atlassian.bitbucket.permission;

import javax.annotation.Nonnull;

/**
 * An effective permission is a permission that is either:
 * <ul>
 *     <li>directly granted (as a permission associated with the user or as a permission associated with a group
 *     the user is a member of),</li>
 *     <li>or indirectly granted through a {@link Permission#getInheritedPermissions() inherited} permission
 *     (such as a {@link Permission#SYS_ADMIN sysadmin} inheriting a
 *     {@link Permission#ADMIN admin} permission).</li>
 * </ul>
 * @deprecated in 5.5 for removal in 6.0 without replacement
 */
@Deprecated
public interface EffectivePermission {

    /**
     * @return the {@link Permission permission}
     */
    @Nonnull
    Permission getPermission();

    /**
     * Accepts the provided {@link EffectivePermissionVisitor visitor} and invokes the appropriate {@code visit} overloaded method.
     * @param visitor the visitor
     * @return the result of the invoked {@code visit} method
     */
    <T> T accept(@Nonnull EffectivePermissionVisitor<T> visitor);
}
