package com.atlassian.bitbucket.label;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public class LabelableSearchRequest {

    private final Label label;
    private final LabelableType type;

    private LabelableSearchRequest(Builder builder) {
        label = builder.label;
        type = builder.type;
    }

    @Nonnull
    public Label getLabel() {
        return label;
    }

    @Nonnull
    public Optional<LabelableType> getType() {
        return Optional.ofNullable(type);
    }

    public static class Builder {

        private final Label label;
        private LabelableType type;

        public Builder(@Nonnull Label value) {
            this.label = requireNonNull(value, "label");
        }

        @Nonnull
        public LabelableSearchRequest build() {
            return new LabelableSearchRequest(this);
        }

        @Nonnull
        public Builder type(@Nullable LabelableType value) {
            this.type = value;
            return this;
        }
    }
}