package com.atlassian.bitbucket.hook.repository;

/**
 * Represents the supported types of {@link RepositoryHook}.
 * <p>
 * This determines where the hook is displayed on the hook settings screen.
 */
public enum RepositoryHookType {

    /**
     * Represents a pre-receive hook, which are used to restrict pushing/merging in some instances.
     */
    PRE_RECEIVE,
    /**
     * Represents a pre-receive hook, which are used to enforce a specific precondition for a pull-request merge operation.
     *
     * @since 5.2
     */
    PRE_PULL_REQUEST_MERGE,
    /**
     * Represents a post-receive hook, which are used to trigger actions after a successful push/merge.
     */
    POST_RECEIVE
}
