package com.atlassian.bitbucket.hook;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Factory for {@link HookHandler} instances for a given {@link HookRequest}.
 */
public interface ScmHookHandlerFactory {

    /**
     * @param request the hook request
     * @return a {@link HookHandler} for handling the provided request. Can be {@code null} if there is no handler for
     *         the provided request.
     */
    @Nullable
    HookHandler create(@Nonnull HookRequest request);
}
