package com.atlassian.bitbucket.event.task;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.task.Task;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base type for all {@link Task task}-related events.
 */
@TransactionAware
public abstract class TaskEvent extends ApplicationEvent {

    private final Task task;

    /**
     * Constructs a new {@code TaskEvent}.
     *
     * @param source the component raising the event
     * @param task   the affected task
     */
    protected TaskEvent(@Nonnull Object source, @Nonnull Task task) {
        super(source);

        this.task = checkNotNull(task, "task");
    }

    @Nonnull
    public Task getTask() {
        return task;
    }

}
