package com.atlassian.bitbucket.event.server;

import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event that is raised when the HTTP(S) SCM hosting is enabled or disabled.
 */
@AsynchronousPreferred
public class HttpScmHostingChangedEvent extends ApplicationConfigurationChangedEvent<Boolean> {

    public HttpScmHostingChangedEvent(@Nonnull Object source, @Nonnull Boolean oldValue, @Nonnull Boolean newValue) {
        super(source, Property.HTTP_SCM_HOSTING, checkNotNull(oldValue, "oldValue"), checkNotNull(newValue, "newValue"));
    }
}
