package com.atlassian.bitbucket.event.server;

import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event that is published when the application setup is completed.
 */
@AsynchronousPreferred
public class ApplicationSetupEvent extends ApplicationConfigurationChangedEvent<Boolean> {

    public ApplicationSetupEvent(@Nonnull Object source, @Nonnull Boolean oldValue, @Nonnull Boolean newValue) {
        super(source, Property.SERVER_IS_SETUP, checkNotNull(oldValue, "oldValue"), checkNotNull(newValue, "newValue"));
    }

    // overridden to set the nullability to non-null
    @Nonnull
    @Override
    @SuppressWarnings("ConstantConditions")
    public Boolean getOldValue() {
        return super.getOldValue();
    }

    // overridden to set the nullability to non-null
    @Nonnull
    @Override
    @SuppressWarnings("ConstantConditions")
    public Boolean getNewValue() {
        return super.getNewValue();
    }
}
