package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event that is raised when the pull request title, description, or target branch are updated.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.updated")
public class PullRequestUpdatedEvent extends PullRequestEvent {

    private final String previousDescription;
    private final String previousTitle;
    private final Ref previousToBranch;

    public PullRequestUpdatedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                   @Nonnull String previousTitle, @Nullable String previousDescription,
                                   @Nullable Ref previousToBranch) {
        super(source, pullRequest, PullRequestAction.UPDATED);

        this.previousDescription = previousDescription;
        this.previousTitle = checkNotNull(previousTitle, "previousTitle");
        this.previousToBranch = previousToBranch;
    }

    @Nullable
    public String getPreviousDescription() {
        return previousDescription;
    }

    @Nonnull
    public String getPreviousTitle() {
        return previousTitle;
    }

    /**
     * @return the previous destination branch <i>if</i> it has changed, otherwise {@code null}
     */
    @Nullable
    public Ref getPreviousToBranch() {
        return previousToBranch;
    }
}
