package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user, group or all licensed users have their permission revoked for a given project.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public class ProjectPermissionRevokedEvent extends ProjectPermissionEvent implements PermissionRevokedEvent {

    public ProjectPermissionRevokedEvent(Object source, Permission permission, Project project,
                                         String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, project, affectedGroup, affectedUser);
    }
}
