package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user, group or all licensed users are granted permission to a given project.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public class ProjectPermissionGrantedEvent extends ProjectPermissionEvent implements PermissionGrantedEvent {

    public ProjectPermissionGrantedEvent(Object source, Permission permission, Project project,
                                         String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, project, affectedGroup, affectedUser);
    }
}
