package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user or group are granted a global permission.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public class GlobalPermissionGrantedEvent extends GlobalPermissionEvent implements PermissionGrantedEvent {

    public GlobalPermissionGrantedEvent(Object source, Permission permission,
                                        String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, affectedGroup, affectedUser);
    }
}
