package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @see GlobalPermissionModificationRequestedEvent
 * @see GlobalPermissionModifiedEvent
 */
public abstract class AbstractGlobalPermissionModificationEvent extends GlobalPermissionEvent {

    private final Permission oldValue;

    protected AbstractGlobalPermissionModificationEvent(Object source,
                                                        Permission oldValue, Permission newValue,
                                                        String affectedGroup, ApplicationUser affectedUser) {
        super(source, newValue, affectedGroup, affectedUser);

        this.oldValue = checkNotNull(oldValue, "oldValue");
        checkArgument(oldValue.isGlobal() && oldValue.isGrantable(), "oldValue must be a grantable global permission");
    }

    @Nonnull
    public Permission getNewValue() {
        return getPermission();
    }

    @Nonnull
    public Permission getOldValue() {
        return oldValue;
    }

}
