package com.atlassian.bitbucket.event.hook;


import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Fired when a repository hook is enabled
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.hook.enabled")
public class RepositoryHookEnabledEvent extends RepositoryHookEvent {

    /**
     * @deprecated in 5.2 for removal in 6.0. Use {@link #RepositoryHookEnabledEvent(Object, Scope, String)} instead.
     */
    @Deprecated
    public RepositoryHookEnabledEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull String repositoryHookKey) {
        super(source, repository, repositoryHookKey);
    }

    /**
     * @since 5.2
     */
    public RepositoryHookEnabledEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull String repositoryHookKey) {
        super(source, repositoryHookKey, scope);
    }
}
