package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base type for all commit discussion-related events.
 */
@TransactionAware
public abstract class CommitDiscussionEvent extends RepositoryEvent {

    private final CommitDiscussion discussion;

    protected CommitDiscussionEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion) {
        super(source, checkNotNull(discussion, "discussion").getRepository());

        this.discussion = discussion;
    }

    @Nonnull
    public CommitDiscussion getDiscussion() {
        return discussion;
    }
}
