package com.atlassian.bitbucket.event.commit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is added in a commit discussion.
 * <p>
 * This does not include replies, which raise a {@link CommitDiscussionCommentRepliedEvent}.
 */
@AsynchronousPreferred
@EventName("stash.commit.comment.added")
public class CommitDiscussionCommentAddedEvent extends CommitDiscussionCommentEvent {

    public CommitDiscussionCommentAddedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                             @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, discussion, comment, parent, CommentAction.ADDED);
    }
}
