package com.atlassian.bitbucket.event.backup;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a backup is canceled by a system administrator.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
@EventName("stash.backup.cancelled")
public class BackupCanceledEvent extends BackupEndedEvent {

    public BackupCanceledEvent(@Nonnull Object source) {
        super(source);
    }
}
