package com.atlassian.bitbucket.event.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Represents an AuditEvent derived from an {@link Audited Audited} annotated event
 */
@AsynchronousPreferred
public class AuditEvent extends ApplicationEvent {

    private final AuditEntry entry;
    private final Set<String> channels;
    private final Priority priority;

    public AuditEvent(@Nonnull Object source, @Nonnull AuditEntry entry, @Nonnull Set<String> channels, Priority priority) {
        super(checkNotNull(source, "source"));
        this.priority = priority;
        this.entry = checkNotNull(entry, "entry");
        this.channels = Collections.unmodifiableSet(checkNotNull(channels, "channels"));
    }

    /**
     * @return the details of the original event in a standard audit format
     * */
    @Nonnull
    public AuditEntry getEntry() {
        return entry;
    }

    /**
      * @return the channels which the original annotated event indicated would be interested in auditing the original event
     */
    @Nonnull
    public Set<String> getChannels() {
        return channels;
    }

    /**
     * @return the priority of the event
     * */
    @Nonnull
    public Priority getPriority() {
        return priority;
    }
}
