package com.atlassian.bitbucket.event.annotation;

import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.audit.Priority;

import java.lang.annotation.*;

/**
 * Indicates that the annotated type is an event which should be audited, added to the audit log and potentially other channels
 * <p>
 * Only affects types used as arguments in {@link com.atlassian.event.api.EventPublisher#publish}
 */

@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Audited {

    /**
     * @return a converter to extract the details of the event to be recorded
     */
    Class<? extends AuditEntryConverter> converter();

    /**
     * @return additional channels the audit details should be sent to in addition to the audit log.
     */
    String[] channels() default {};

    /**
     * @return the priority of the event
     */
    Priority priority();
}
