package com.atlassian.bitbucket.content;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Represents a remote link in a source tree
 */
public abstract class Submodule implements ContentTreeNode {

    /**
     * @return an optional URL to the <i>remote</i> submodule repository at a specific commit, or {@code null}.
     *         The structure of this URL is dependent on the hosting server (e.g. Bitbucket or Github).
     */
    @Nullable
    public abstract String getBrowseUrl();

    /**
     * @return an optional URL to the <i>remote</i> repository containing this submodule, or {@code null}.
     */
    @Nullable
    public abstract String getRepositoryUrl();

    @Nonnull
    @Override
    public Type getType() {
        return Type.SUBMODULE;
    }

    /**
     * @return the mandatory SCM URL to the <i>remote</i> repository.
     */
    @Nonnull
    public abstract String getUrl();
}
