package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.property.SimplePropertySupport;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangeContext extends SimplePropertySupport {

    private final String fromHash;
    private final int maxChanges;
    private final String toHash;

    private ChangeContext(Builder builder) {
        super(builder);

        fromHash = builder.fromHash;
        maxChanges = builder.maxChanges;
        toHash = builder.toHash;
    }

    @Nullable
    public String getFromHash() {
        return fromHash;
    }

    public int getMaxChanges() {
        return maxChanges;
    }

    @Nonnull
    public String getToHash() {
        return toHash;
    }

    public static class Builder extends AbstractPropertyBuilder<Builder> {

        private final String fromHash;
        private final String toHash;

        private int maxChanges;

        public Builder(@Nullable String fromHash, @Nonnull String toHash) {
            this.fromHash = StringUtils.trimToNull(fromHash);
            this.toHash = checkNotBlank(toHash, "toHash");
        }

        /**
         * @since 4.10
         */
        public Builder(@Nonnull ChangeContext context) {
            super(context);

            fromHash = context.fromHash;
            toHash = context.toHash;
            maxChanges = context.maxChanges;
        }

        @Nonnull
        public ChangeContext build() {
            return new ChangeContext(this);
        }

        @Nonnull
        public Builder maxChanges(int value) {
            maxChanges = value;

            return this;
        }


        /**
         * @since 4.10
         */
        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
