package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * Defines a request to retrieve commits which are ancestors of a given {@link #getCommitId() starting commit}.
 */
public class CommitsRequest extends AbstractCommitsRequest {

    private final String commitId;

    private CommitsRequest(Builder builder) {
        super(builder);

        commitId = builder.commitId;
    }

    /**
     * @return the ID of the commit to load, which may be a branch or tag name or a {@link Commit#getId() commit ID}
     */
    @Nonnull
    public String getCommitId() {
        return commitId;
    }


    public static class Builder extends AbstractCommitsRequestBuilder<Builder> {

        private final String commitId;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            super(repository);

            this.commitId = requireNonBlank(commitId, "commitId");
        }

        @Nonnull
        public CommitsRequest build() {
            return new CommitsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}
