package com.atlassian.bitbucket.avatar;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

public class NoSuchAvatarException extends NoSuchEntityException {

    private final String id;

    public NoSuchAvatarException(@Nonnull KeyedMessage message, @Nonnull String id) {
        super(message);

        this.id = checkNotNull(id, "id");
    }

    @Nonnull
    public String getId() {
        return id;
    }
}
